IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_ATU_VD_EXEC_ALL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_ATU_VD_EXEC_ALL]
GO 
SET ANSI_NULLS ON
GO 
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE  P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_ATU_VD_EXEC_ALL (@CD_EMP INT=1, @DT_ATUAL DATETIME=NULL)
AS
	DECLARE @CD_FILIAL INT;

	DECLARE  CurFiliaisAnalise CURSOR FAST_FORWARD 
	FOR 
	SELECT 
		CD_FILIAL
	FROM 
		PRC_FILIAL A
	WHERE 
		A.CD_EMP = @CD_EMP   
		AND A.STS_FILIAL=0
	ORDER BY A.CD_FILIAL;		
	 
	OPEN CurFiliaisAnalise 
	FETCH NEXT FROM CurFiliaisAnalise INTO @CD_FILIAL
	WHILE @@FETCH_STATUS=0
	  BEGIN
		PRINT	'  Filial ' + CONVERT(VARCHAR(5), @CD_FILIAL) + 
				' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'
 	 
		exec P_ANALISE_VENDA_PRODUTOS_DIARIA_FILIAL_ATU_VD  @CD_EMP,@CD_FILIAL,@DT_ATUAL 
		FETCH NEXT FROM CurFiliaisAnalise INTO @CD_FILIAL
	  END
	  
	PRINT 'Concluido.'
	CLOSE CurFiliaisAnalise
	DEALLOCATE CurFiliaisAnalise
